#!/bin/sh
#
# Functions for building AlmaLinux packages.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

# Build packages for AlmaLinux from the extracted source at
# ${workDir}/build-source/ and place them in ${destinationPath}, using the
# build instructions at ${workDir}/build-instructions/.
#
# If $1 is "check-prerequisites", just check that the commands are available
# to build packages for the target OS, returning 0 if OK,
# ${RC_NOT_SUPPORTED} if not OK.
#
build_package_almalinux () {
	if test "$1" = 'check-prerequisites'; then
		for checkCommand in 'rpm' 'rpmbuild'; do
			command -v "${checkCommand}" >/dev/null 2>&1 && continue
			reportError "${checkCommand}: command not found - cannot build packages for ${targetOs}"
			return "${RC_NOT_SUPPORTED}"
		done
		return 0
	fi

	# In container mode, do the rest inside a container instead.
	if ! ${nativeOnly}; then
		if ! test "${action}" = 'inside-container'; then
			loadComponent 'containers'
			runInContainer 'containers build-package-almalinux build-package-centos7' 'build-package' || return $?
			# Copy the generated packages to the destination.
			cp "${workDir}/packages/"* "${destinationPath}/" || return "${RC_LOCAL_FAULT}"
			return 0
		fi
	fi

	# The process is the same as for CentOS 7.
	type build_package_centos7 >/dev/null 2>&1 || loadComponent 'build-package-centos7'
	build_package_centos7 "$@"
	return $?
}


# Extract build instructions for this OS from the extracted source under
# ${workDir}/build-source/ and place them under
# ${workDir}/build-instructions/ if any were found.
#
extract_instructions_almalinux () {
	extractInstructionsForRPM "${workDir}/build-source" "${workDir}/build-instructions"
}
