#!/bin/sh
#
# Functions for building Ubuntu packages.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

# Build packages for Ubuntu from the extracted source at
# ${workDir}/build-source/ and place them in ${destinationPath}, using the
# build instructions at ${workDir}/build-instructions/.
#
# If $1 is "check-prerequisites", just check that the commands are available
# to build packages for the target OS, returning 0 if OK,
# ${RC_NOT_SUPPORTED} if not OK.
#
build_package_ubuntu () {
	type build_package_debian >/dev/null 2>&1 || loadComponent 'build-package-debian'
	build_package_debian "$@"
}


# Extract build instructions for this OS from the extracted source under
# ${workDir}/build-source/ and place them under
# ${workDir}/build-instructions/ if any were found.
#
extract_instructions_ubuntu () {
	type extract_instructions_debian >/dev/null 2>&1 || loadComponent 'build-package-debian'
	extract_instructions_debian "$@"
}
