#!/bin/sh
#
# The "help" action.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

showHelp () {
	printf '%s: %s %s\n' 'Usage' "${PROGRAM_NAME}" '[OPTION]... ACTION [ARGUMENT]...'
	printf '%s\n\n' 'Maintain local packages and package repositories.'
	printf '%s\n' 'Options:'
	printf '  -n, --native                %s\n' 'native commands only - no containers'
	printf '  -t, --target OS             %s\n' 'set target operating system'
	printf '  -s, --source PATH           %s\n' 'specify data source'
	printf '  -i, --instructions PATH     %s\n' 'specify build instructions'
	printf '  -d, --destination PATH      %s\n' 'specify output directory'
	printf '  -k, --key FILE              %s\n' 'key file for signing packages'
	printf '  -p, --passphrase FILE       %s\n' 'file containing passphrase for key'
	printf '  -c, --constraint KEY=VALUE  %s\n' 'apply a constraint to the action'
	printf '  -u, --user NAME             %s\n' 'specify who is performing the action'
	printf '  -q, --quiet                 %s\n' 'decrease verbosity'
	printf '  -v, --verbose               %s\n' 'increase verbosity'
	printf '  -h, --help                  %s\n' 'show this help and exit'
	printf '  -V, --version               %s\n' 'show version information and exit'
	printf '\n%s\n' 'Actions:'
	printf '  build-package               %s\n' 'build a package from source'
	printf '  build-instructions          %s\n' 'generate package build instructions'
	printf '  update-info                 %s\n' 'produce a package information file'
	printf '  index-repository            %s\n' 'index a repository of packages'
	printf '  archive-contents            %s\n' 'list contents of a package archive'
	printf '  prune COUNT                 %s\n' 'remove old packages until COUNT remain'
	printf '  repository-contents         %s\n' 'list contents of a package repository'
	printf '  select PACKAGE VERSION      %s\n' 'place a package into a repository'
	printf '  pin PACKAGE VERSION [NOTE]  %s\n' 'update version pinning status'
	printf '  update-image                %s\n' 'apply OS updates to a build image'
	printf '  install-into-image PACKAGE  %s\n' 'install PACKAGE into a build image'
	printf '  targets                     %s\n' 'list target operating systems'
	printf '\n%s <%s>.\n' 'Please report any bugs to' "${PACKAGE_BUGREPORT}"
}
