#!/bin/sh
#
# Functions for indexing repositories for Ubuntu packages.
#
# Copyright 2025 Andrew Wood
#
# License GPLv3+: GNU GPL version 3 or later; see `docs/COPYING'.
#

# Index the Ubuntu packages in directory $1, and write the index to
# directory $2.  The two directories can be the same.
#
# If $3 is "check-prerequisites", just check that the commands are available
# to index repositories for the target OS, returning 0 if OK,
# ${RC_NOT_SUPPORTED} if not OK.
#
index_repository_ubuntu () {
	type index_repository_debian >/dev/null 2>&1 || loadComponent 'index-repository-debian'
	index_repository_debian "$@"
}
